/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_dd.blocks.flywheel;

import com.jozufozu.flywheel.backend.Backend;
import com.jozufozu.flywheel.core.PartialModel;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.HorizontalKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.AngleHelper;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_761;
import uwu.lopyluna.create_dd.blocks.flywheel.FlywheelBlock;
import uwu.lopyluna.create_dd.blocks.flywheel.FlywheelBlockEntity;
import uwu.lopyluna.create_dd.client.registry.DDBlockPartials;

public class FlywheelRenderer
extends KineticBlockEntityRenderer {
    public FlywheelRenderer(class_5614.class_5615 context) {
        super(context);
    }

    protected void renderSafe(KineticBlockEntity te, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay) {
        super.renderSafe(te, partialTicks, ms, buffer, light, overlay);
        if (Backend.canUseInstancing((class_1937)te.method_10997())) {
            return;
        }
        class_2680 blockState = te.method_11010();
        FlywheelBlockEntity wte = (FlywheelBlockEntity)te;
        float speed = wte.visualSpeed.getValue(partialTicks) * 3.0f / 10.0f;
        float angle = wte.angle + speed * partialTicks;
        class_4588 vb = buffer.getBuffer(class_1921.method_23577());
        if (FlywheelBlock.isConnected(blockState)) {
            class_2350 connection = FlywheelBlock.getConnection(blockState);
            light = class_761.method_23793((class_1920)te.method_10997(), (class_2680)blockState, (class_2338)te.method_11016().method_10093(connection));
            float rotation = connection.method_10166() == class_2350.class_2351.field_11048 ^ connection.method_10171() == class_2350.class_2352.field_11060 ? -angle : angle;
            boolean flip = blockState.method_11654(FlywheelBlock.CONNECTION) == FlywheelBlock.ConnectionState.LEFT;
            this.transformConnector(this.rotateToFacing(CachedBufferer.partial((PartialModel)DDBlockPartials.FLYWHEEL_UPPER_ROTATING, (class_2680)blockState), connection), true, true, rotation, flip).light(light).renderInto(ms, vb);
            this.transformConnector(this.rotateToFacing(CachedBufferer.partial((PartialModel)DDBlockPartials.FLYWHEEL_LOWER_ROTATING, (class_2680)blockState), connection), false, true, rotation, flip).light(light).renderInto(ms, vb);
            this.transformConnector(this.rotateToFacing(CachedBufferer.partial((PartialModel)DDBlockPartials.FLYWHEEL_UPPER_SLIDING, (class_2680)blockState), connection), true, false, rotation, flip).light(light).renderInto(ms, vb);
            this.transformConnector(this.rotateToFacing(CachedBufferer.partial((PartialModel)DDBlockPartials.FLYWHEEL_LOWER_SLIDING, (class_2680)blockState), connection), false, false, rotation, flip).light(light).renderInto(ms, vb);
        }
        this.renderFlywheel(te, ms, light, blockState, angle, vb);
    }

    private void renderFlywheel(KineticBlockEntity te, class_4587 ms, int light, class_2680 blockState, float angle, class_4588 vb) {
        class_2680 referenceState = blockState.method_26186(class_2470.field_11463);
        class_2350 facing = (class_2350)referenceState.method_11654((class_2769)class_2741.field_12481);
        SuperByteBuffer wheel = CachedBufferer.partialFacing((PartialModel)DDBlockPartials.FLYWHEEL, (class_2680)referenceState, (class_2350)facing);
        FlywheelRenderer.kineticRotationTransform((SuperByteBuffer)wheel, (KineticBlockEntity)te, (class_2350.class_2351)((class_2350)blockState.method_11654(HorizontalKineticBlock.HORIZONTAL_FACING)).method_10166(), (float)AngleHelper.rad((double)angle), (int)light);
        wheel.renderInto(ms, vb);
    }

    protected SuperByteBuffer getRotatedModel(KineticBlockEntity te, class_2680 state) {
        return CachedBufferer.partialFacing((PartialModel)AllPartialModels.SHAFT_HALF, (class_2680)state, (class_2350)((class_2350)state.method_11654((class_2769)class_2741.field_12481)).method_10153());
    }

    protected SuperByteBuffer transformConnector(SuperByteBuffer buffer, boolean upper, boolean rotating, float angle, boolean flip) {
        float shift = upper ? 0.25f : -0.125f;
        float offset = upper ? 0.25f : 0.25f;
        float radians = (float)((double)(angle / 180.0f) * Math.PI);
        float shifting = class_3532.method_15374((float)radians) * shift + offset;
        float maxAngle = upper ? -5.0f : -15.0f;
        float minAngle = upper ? -45.0f : 5.0f;
        float barAngle = 0.0f;
        if (rotating) {
            barAngle = class_3532.method_16439((float)((class_3532.method_15374((float)((float)((double)radians + 1.5707963267948966))) + 1.0f) / 2.0f), (float)minAngle, (float)maxAngle);
        }
        float pivotX = (upper ? 8.0f : 3.0f) / 16.0f;
        float pivotY = (upper ? 8.0f : 2.0f) / 16.0f;
        float pivotZ = (upper ? 23.0f : 21.5f) / 16.0f;
        buffer.translate((double)pivotX, (double)pivotY, (double)(pivotZ + shifting));
        if (rotating) {
            buffer.rotate(class_2350.field_11034, AngleHelper.rad((double)barAngle));
        }
        buffer.translate((double)(-pivotX), (double)(-pivotY), (double)(-pivotZ));
        if (flip && !upper) {
            buffer.translate(0.5625, 0.0, 0.0);
        }
        return buffer;
    }

    protected SuperByteBuffer rotateToFacing(SuperByteBuffer buffer, class_2350 facing) {
        buffer.rotateCentered(class_2350.field_11036, AngleHelper.rad((double)AngleHelper.horizontalAngle((class_2350)facing)));
        return buffer;
    }
}

